/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.entity.rule;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;


public abstract class AbstractEntityMappingFactory implements IEntityMappingFactory {
	
	public static IEntityMappingFactory getFactory(IDBConfig config) {
		return getFactory(config.getDriverName());
	}
	
	public static IEntityMappingFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode) {
		try {
			return getFactory(objMet.getDriverName());
			
		} catch (SQLException e) {
			throw new IllegalStateException("DriverName̎擾Ɏs܂"); //$NON-NLS-1$
		}
		
	}
	
	private static Map map = new HashMap();
	
	public static IEntityMappingFactory getFactory(String driverName) {
		IEntityMappingFactory factory = null;
		String key = driverName;
		if (map.containsKey(key)) {
			factory = (IEntityMappingFactory) map.get(key);
		} else {
			switch (DBType.getType(driverName)) {
				case DBType.DB_TYPE_ORACLE:
					factory = new OracleEntityMappingFactory();
					break;
				case DBType.DB_TYPE_H2:
					factory = new H2EntityMappingFactory();
					break;
				default:
					factory = new DefaultEntityMappingFactory();
					break;
			}
			
			map.put(key, factory);
		}
		return factory;
	}
}